//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Create OCSP Request
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define OCSP_REQ_FILE "ocsp_req.bin"
#define CHECK_CERT    "cmp_ra.cer"
//------------------------------------------------------------------------------
unsigned char WBuf[8196];
unsigned char Cert[8196];
//------------------------------------------------------------------------------
//         
// :
// 1.  OCSP     
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTKEY hKey,hExpKey=0;
 DWORD len,sz;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //   
 if (getFileLen(CHECK_CERT,    &sz)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (CHECK_CERT,Cert,sz)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,(char*)CSP_PROF,0,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //
 //  hExpKey    ,     requestorName
 //    
 if (!CPGetUserKey(hProv,AT_SIGNATURE,&hExpKey)) {
   printf("CPGetUserKey AT_SIGNATURE Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //
 //   
 if (!CPImportKey(hProv,Cert,sz,0,0,&hKey)) {
   printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 len=sizeof(WBuf);
 if (!CPExportKey(hProv,hKey,hExpKey,PUBLICKEYBLOB_OCSP,0,WBuf,&len)) {
   printf("CPExportKey PUBLICKEYBLOB_OCSP Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 writeFile(OCSP_REQ_FILE,WBuf,len);
 //
 CPDestroyKey(hProv,hKey);
 CPDestroyKey(hProv,hExpKey);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
